import { Link, useLocation } from 'react-router-dom'
import { Brain } from 'lucide-react'
import { motion } from 'framer-motion'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <motion.div 
              className="logo"
              whileHover={{ scale: 1.05 }}
              transition={{ type: "spring", stiffness: 400 }}
            >
              <Brain className="logo-icon" size={28} color="#3B82F6" />
              <span className="logo-text">TutorPro</span>
            </motion.div>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои уроки
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Назначить урок
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main">
        {children}
      </main>

      <footer className="footer">
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <Brain className="footer-logo-icon" size={24} color="#60A5FA" />
                <h2>TutorPro</h2>
              </div>
              <p className="footer-description">
                Профессиональное онлайн-репетиторство по школьным предметам с опытными преподавателями
              </p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li>
                  <span>Телефон:</span>
                  <a href="tel:+79991234567">+7 (999) 123-45-67</a>
                </li>
                <li>
                  <span>Email:</span>
                  <a href="mailto:info@tutorpro.ru">info@tutorpro.ru</a>
                </li>
                <li>
                  <span>Адрес:</span>
                  <span>г. Москва, ул. Образовательная, д. 1</span>
                </li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Режим работы</h3>
              <ul className="footer-links">
                <li>Пн-Пт: 9:00 - 21:00</li>
                <li>Сб: 10:00 - 18:00</li>
                <li>Вс: Выходной</li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            <p>&copy; 2025 TutorPro. Все права защищены.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

